(**********************************************
 **              Unit DemoForm               **
 ** ---------------------------------------- **
 **             Demo Exe-Button              **
 ** ---------------------------------------- **
 **                                          **
 **  Delphi 1.01 and 2.0 / MAINFORM.PAS / HD **
 **  created        : 10.02.1996             **
 **  last Update    : 08.08.1996             **
 **                                          **
 **********************************************)

unit Demoform;

{=============================================}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs,
  {$ifdef win32}
    Exebtn32,
  {$else}
    ExeBtn,
  {$endif}
  StdCtrls,ExtCtrls, Buttons;

type
  TFormDemo = class(TForm)
    Panel1: TPanel;
    ExeBtn6: TExeBtn;
    ExeBtn1: TExeBtn;
    ExeBtn2: TExeBtn;
    ExeBtn3: TExeBtn;
    Panel2: TPanel;
    Label2: TLabel;
    Label1: TLabel;
    ExeBtn4: TExeBtn;
    Panel3: TPanel;
    Label3: TLabel;
    ExeBtn5: TExeBtn;
    Timer1: TTimer;
    CheckBox2: TCheckBox;
    CheckBox1: TCheckBox;
    LabelInfo: TLabel;
    Panel4: TPanel;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    RadioButton3: TRadioButton;
    RadioButton4: TRadioButton;
    Label4: TLabel;
    Panel5: TPanel;
    Label6: TLabel;
    Label8: TLabel;
    Label7: TLabel;
    ScrollBar1: TScrollBar;
    CheckBox3: TCheckBox;
    ScrollBar2: TScrollBar;
    Label5: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    CheckBox4: TCheckBox;
    Panel6: TPanel;
    procedure FormCreate(Sender: TObject);
    procedure ExeBtn6Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure RadioButton1Click(Sender: TObject);
    procedure ExeBtn5Click(Sender: TObject);
    procedure ScrollBar1Change(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure ScrollBar2Change(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
    procedure ShowHint(Sender: TObject);
    procedure CheckWinDir(ExeBtnStr:string);
  end;

var
  FormDemo: TFormDemo;

{=============================================}

implementation

{$R *.DFM}

{----------------------------------------------
 shows the hint in a label }

procedure TFormDemo.ShowHint(Sender: TObject);
begin
  LabelInfo.Caption := ' '+Application.Hint;
end;

{----------------------------------------------
 Get windows-directory }

function GetWinDirStr:string;
var WinDirSz:array[0..128] of char;
    WinDirStr:string;
begin
  GetWindowsDirectory(WinDirSz,sizeof(WinDirSz));
  Result:=StrPas(WinDirSz);
end;

{----------------------------------------------}

procedure TFormDemo.CheckWinDir(ExeBtnStr:string);
var WinDirStr,s:string;
    p:byte;
    Component:TComponent;
begin
  Component:=FindComponent(ExeBtnStr);

  WinDirStr:=GetWinDirStr;
  {ExeFile}
  p:=Pos('C:\WINDOWS',UpperCase((Component as TExeBtn).ExeFile));
  if p<>0 then begin
    s:=(Component as TExeBtn).ExeFile;
    Delete(s,p,10);
    s:=WinDirStr+s;
    (Component as TExeBtn).ExeFile:=s;
  end;
  {ExeIconFile}
  p:=Pos('C:\WINDOWS',UpperCase((Component as TExeBtn).ExeIconFile));
  if p<>0 then begin
    s:=(Component as TExeBtn).ExeIconFile;
    Delete(s,p,10);
    s:=WinDirStr+s;
    (Component as TExeBtn).ExeIconFile:=s;
  end;
end;

{----------------------------------------------}

procedure TFormDemo.FormCreate(Sender: TObject);
var i:byte;
    CoolDllStr:String;
begin
  { Hints in a label }
  Top:=0;
  Left:=Screen.Width-Width;
  Application.OnHint:=ShowHint;
  LabelInfo.Caption:='';

  for i:=1 to 6
  do CheckWinDir('ExeBtn'+IntToStr(i));


  { if FileExists use the file COOL.DLL otherwise MOREICONS.DLL }
  CoolDllStr:=GetWinDirStr+'\SYSTEM\COOL.DLL';
  if FileExists(CoolDllStr) then begin
    ExeBtn5.ExeIconFile:=CoolDllStr;
    ExeBtn5.Hint:='Icons from COOL.DLL';
  end;

  { Show BMP on the EXE-button }
  ExeBtn6.ExeIconFile:=ExtractFilePath(Application.ExeName)+'\exebtn.bmp';
end;

{----------------------------------------------}

procedure TFormDemo.ExeBtn6Click(Sender: TObject);
begin
  case ExeBtn6.Language of
    german : ExeBtn6.ExeParams:=ExtractFilePath(Application.ExeName)+
                                'exeger.wri';
    english: ExeBtn6.ExeParams:=ExtractFilePath(Application.ExeName)+
                                'exeeng.wri';
  end;
end;

{----------------------------------------------}

procedure TFormDemo.Timer1Timer(Sender: TObject);
begin
  if ExeBtn5.ExeIconIndex<40
  then ExeBtn5.ExeIconIndex:=ExeBtn5.ExeIconIndex+1
  else ExeBtn5.ExeIconIndex:=0;

end;

{----------------------------------------------}

procedure TFormDemo.CheckBox1Click(Sender: TObject);
var i:byte;
    Component:TComponent;
begin
  for i:=1 to 6 do begin
    Component:=FindComponent('ExeBtn'+IntToStr(i));
    (Component as TExeBtn).ExeOneInstance:=CheckBox1.Checked;
  end;
end;

{----------------------------------------------}

procedure TFormDemo.CheckBox2Click(Sender: TObject);
var i:byte;
    Component:TComponent;
begin
  for i:=1 to 6 do begin
    Component:=FindComponent('ExeBtn'+IntToStr(i));
    (Component as TExeBtn).ExecAndWait:=CheckBox2.Checked;
  end;
end;

{----------------------------------------------}

procedure TFormDemo.RadioButton1Click(Sender: TObject);
var i:byte;
    Component:TComponent;
begin
  for i:=1 to 6 do begin
    Component:=FindComponent('ExeBtn'+IntToStr(i));
    if RadioButton1.Checked then
    (Component as TExeBtn).ExeShowCmd:=scNormal;
    if RadioButton2.Checked then
    (Component as TExeBtn).ExeShowCmd:=scMaximize;
    if RadioButton3.Checked then
    (Component as TExeBtn).ExeShowCmd:=scMinimize;
    if RadioButton4.Checked then
    (Component as TExeBtn).ExeShowCmd:=scNA;
  end;
end;

{----------------------------------------------}

procedure TFormDemo.ExeBtn5Click(Sender: TObject);
begin
  ShowMessage(ExeBtn5.Hint+'. Great!');
end;

{----------------------------------------------}

procedure TFormDemo.ScrollBar1Change(Sender: TObject);
var i:byte;
    Component:TComponent;
begin
  for i:=1 to 5 do begin
    Component:=FindComponent('ExeBtn'+IntToStr(i));
    (Component as TExeBtn).ExeIconZoom:=Scrollbar1.Position/100;
  end;
end;

{----------------------------------------------}

procedure TFormDemo.SpeedButton1Click(Sender: TObject);
begin
  case (Sender as TSpeedButton).Tag of
    1:ExeBtn1.CloseApp;
    2:ExeBtn2.CloseApp;
    3:ExeBtn3.CloseApp;
    4:ExeBtn4.CloseApp;
  end;
end;

{----------------------------------------------}

procedure TFormDemo.CheckBox3Click(Sender: TObject);
begin
  if CheckBox3.Checked then begin
    Scrollbar2.Position:=0;
    ExeBtn1.BevelWidth:=0;
    ExeBtn2.BevelWidth:=0;
    ExeBtn3.BevelWidth:=0;
    ExeBtn4.BevelWidth:=0;
    ExeBtn5.BevelWidth:=0;
    ExeBtn1.BorderStyle:=bsNone;
    ExeBtn2.BorderStyle:=bsNone;
    ExeBtn3.BorderStyle:=bsNone;
    ExeBtn4.BorderStyle:=bsNone;
    ExeBtn5.BorderStyle:=bsNone;
    ExeBtn1.ExeClick:=ecDblClick;
    ExeBtn2.ExeClick:=ecDblClick;
    ExeBtn3.ExeClick:=ecDblClick;
    ExeBtn4.ExeClick:=ecDblClick;
    ExeBtn5.ExeClick:=ecDblClick;
  end
  else begin
    Scrollbar2.Position:=1;
    ExeBtn1.BevelWidth:=1;
    ExeBtn2.BevelWidth:=1;
    ExeBtn3.BevelWidth:=1;
    ExeBtn4.BevelWidth:=1;
    ExeBtn5.BevelWidth:=1;
    ExeBtn1.BorderStyle:=bsSingle;
    ExeBtn2.BorderStyle:=bsSingle;
    ExeBtn3.BorderStyle:=bsSingle;
    ExeBtn4.BorderStyle:=bsSingle;
    ExeBtn5.BorderStyle:=bsSingle;
    ExeBtn1.ExeClick:=ecClick;
    ExeBtn2.ExeClick:=ecClick;
    ExeBtn3.ExeClick:=ecClick;
    ExeBtn4.ExeClick:=ecClick;
    ExeBtn5.ExeClick:=ecClick;
  end;
end;

procedure TFormDemo.ScrollBar2Change(Sender: TObject);
var i:byte;
    Component:TComponent;
begin
  for i:=1 to 5 do begin
    Component:=FindComponent('ExeBtn'+IntToStr(i));
    (Component as TExeBtn).BevelWidth:=Scrollbar2.Position;
  end;
end;


procedure TFormDemo.CheckBox4Click(Sender: TObject);
var i:byte;
    Component:TComponent;
begin
  if CheckBox4.Checked then begin
    for i:=1 to 5 do begin
      Component:=FindComponent('ExeBtn'+IntToStr(i));
      (Component as TExeBtn).CloseAppKey:=ckCtrl;
    end;
  end
  else begin
    for i:=1 to 5 do begin
      Component:=FindComponent('ExeBtn'+IntToStr(i));
      (Component as TExeBtn).CloseAppKey:=ckNone;
    end;
  end;
end;

end.
